
/**
 * The FancyCopyMachineTester puts a FancyCopyMachine through a series
 * of tests.
 *
 * @author Richard White
 * @version 2020-03-31
 */
public class FancyCopyMachineTester
{
    public static void main(String[] args)
    {     
        int testsPassed = 0;
        
        System.out.print("Creating new copy machine...");
        FancyCopyMachine cm = new FancyCopyMachine();
        System.out.println("passed.");
        testsPassed++;
        System.out.println("-----------");
        
        System.out.print("Adding paper...");
        cm.addPaper(500);
        System.out.println("passed.");
        testsPassed++;
        System.out.println("-----------");
        
        System.out.print("Installing staple cartridge...");
        cm.installStapleCartridge();
        System.out.println("passed.");
        testsPassed++;
        System.out.println("-----------");
        
        System.out.print("Checking paper and staple counts...");
        if (cm.getPaperCount() == 500 && cm.getStapleCount() == 1000)
        {
            testsPassed++;
            System.out.println("passed.");
        }
        else
        {
            System.out.println("failed.");
        }
        System.out.println("Expected state: CopyMachine[paperCount=500,stapleCount=1000]");
        System.out.println("Actual state:   " + cm);
        System.out.println("-----------");
                
        System.out.print("Making two copies of 4-page single-sided document");
        cm.makeCopies(2,4,1,1,false);
        if (cm.getPaperCount() == 492 && cm.getStapleCount() == 1000)
        {
            testsPassed++;
            System.out.println("passed.");
        }
        else
        {
            System.out.println("failed.");
        }
        System.out.println("Expected state: CopyMachine[paperCount=492,stapleCount=1000]");
        System.out.println("Actual state:   " + cm);
        System.out.println("-----------");
        
        System.out.println("Refilling paper...");
        cm.addPaper(500);
        System.out.println("Making two copies of 4-page single-sided document, to double-side copy, 1 ->2");
        cm.makeCopies(2,4,1,2,false);
        if (cm.getPaperCount() == 496 && cm.getStapleCount() == 1000)
        {
            testsPassed++;
            System.out.println("passed.");
        }
        else
        {
            System.out.println("failed.");
        }
        System.out.println("Expected state: CopyMachine[paperCount=496,stapleCount=1000]");
        System.out.println("Actual state:   " + cm);
        System.out.println("-----------");
        
        System.out.println("Refilling paper...");
        cm.addPaper(500);
        System.out.println("Making two copies of 4-page double-sided document to single-sided copy, 2 -> 1");
        cm.makeCopies(2,4,2,1,false);
        if (cm.getPaperCount() == 484 && cm.getStapleCount() == 1000)
        {
            testsPassed++;
            System.out.println("passed.");
        }
        else
        {
            System.out.println("failed.");
        }
        System.out.println("Expected state: CopyMachine[paperCount=484,stapleCount=1000]");
        System.out.println("Actual state:   " + cm);
        System.out.println("-----------");
        
        System.out.println("Refilling paper...");
        cm.addPaper(500);
        System.out.println("Making two copies of 4-page double-sided document to double-sided copy, 2 -> 2");
        cm.makeCopies(2,4,2,2,false);
        if (cm.getPaperCount() == 492 && cm.getStapleCount() == 1000)
        {
            testsPassed++;
            System.out.println("passed.");
        }
        else
        {
            System.out.println("failed.");
        }
        System.out.println("Expected state: CopyMachine[paperCount=492,stapleCount=1000]");
        System.out.println("Actual state:   " + cm);
        System.out.println("-----------");
        
        System.out.println("Refilling paper...");
        cm.addPaper(500);
        System.out.println("Making two copies of 3-page, one-sided document");
        cm.makeCopies(2,3,1,1,false);
        if (cm.getPaperCount() == 494 && cm.getStapleCount() == 1000)
        {
            testsPassed++;
            System.out.println("passed.");
        }
        else
        {
            System.out.println("failed.");
        }
        System.out.println("Expected state: CopyMachine[paperCount=494,stapleCount=1000]");
        System.out.println("Actual state:   " + cm);
        System.out.println("-----------");
        
        System.out.println("Refilling paper...");
        cm.addPaper(500);
        System.out.println("Making two copies of 3-page, one-sided document onto double-sided copy, 1 -> 2");
        cm.makeCopies(2,3,1,2,false);
        if (cm.getPaperCount() == 496 && cm.getStapleCount() == 1000)
        {
            testsPassed++;
            System.out.println("passed.");
        }
        else
        {
            System.out.println("failed.");
        }
        System.out.println("Expected state: CopyMachine[paperCount=496,stapleCount=1000]");
        System.out.println("Actual state:   " + cm);
        System.out.println("-----------");
        
        System.out.println("Refilling paper");
        cm.addPaper(500);
        System.out.println("Making two copies of 3-page, double-sided document onto single-sided copy, 2 -> 1");
        cm.makeCopies(2,3,2,1,false);
        if (cm.getPaperCount() == 488 && cm.getStapleCount() == 1000)
        {
            testsPassed++;
            System.out.println("passed.");
        }
        else
        {
            System.out.println("failed.");
        }
        System.out.println("Expected state: CopyMachine[paperCount=488,stapleCount=1000]");
        System.out.println("Actual state:   " + cm);
        System.out.println("-----------");
        
        System.out.println("Refilling paper");
        cm.addPaper(500);
        System.out.println("Making two copies of 3-page double-sided document onto double-sided copy, 2 -> 2");
        cm.makeCopies(2,3,2,2,false);
        if (cm.getPaperCount() == 494 && cm.getStapleCount() == 1000)
        {
            testsPassed++;
            System.out.println("passed.");
        }
        else
        {
            System.out.println("failed.");
        }
        System.out.println("Expected state: CopyMachine[paperCount=494,stapleCount=1000]");
        System.out.println("Actual state:   " + cm);
        System.out.println("-----------");
        
        System.out.println("Tests passed: " + testsPassed + "/12");
    }
}
