
/**
 * The FancyCopyMachine class simulates an office copier (a "Xerox
 * machine") that makes copies of standard paper documents.
 * 
 * It has the ability to staple documents automatically, and can
 * copy 1-sided to 1-sided, 1-sided to 2-sided, 2-sided to 2-sided,
 * and 2-sided to 1-sided. It can hold a maximum of one ream of 
 * paper at a time (500 sheets), and the standard staple cartridge 
 * comes with 1000 staples--one can't add individual staples.
 *
 * @author 
 * @version 
 */
public class FancyCopyMachine
{
    // instance variables - replace the example below with your own
    private int paperCount;
    private int stapleCount;
    public final int MAX_PAPER = 500;

    /**
     * A new FancyCopyMachine has no paper and no staples in it.
     */
    public FancyCopyMachine()
    {
        // initialise instance variables
        paperCount = 0;
        stapleCount = 0;
    }

    /**
     * This method adds a specified amount of paper to the machine,
     * up to its maximum capacity.
     * @param  sheetsAdded the number of sheets of paper added
     */
    public void addPaper(int sheets)
    {
        // put your code here
        paperCount += sheets;
        if (paperCount > MAX_PAPER)
            paperCount = MAX_PAPER;
    }

    /**
     * This method installs a new staple cartridge into the machine.
     */
    public void installStapleCartridge()
    {
        stapleCount = 1000;
    }

    /**
     * Identifies how many sheets of blank paper are in the copier.
     * @return the current paper count
     */
    public int getPaperCount()
    {
        return paperCount;
    }

    /**
     * Identifies how many staples are currently in the cartridge.
     * @return the current staple count
     */
    public int getStapleCount()
    {
        return stapleCount;
    }

    /**
     * This method makes copies on the machine according to the 
     * parameters indicated.
     * @param copyCount the number of copies to be made
     * @param numOriginals the number of sheets (not pages) to be copied
     * @param originalSides the number of sides (1 or 2) in the original
     * @param copySides the number of sides (1 or 2) in the copies to be made
     * @param staple a boolean value, true if copies are to be stapled
     * @return an error code, based on the result of the copying:
     *         0: no error
     *         1: insufficient paper for copying
     *         2: insufficient staples for copying
     */
    public int makeCopies(int copyCount,
                          int numOriginals, 
                          int originalSides,
                          int copySides,
                          boolean staple)
    {
        // insert code here
        
    }

    /**
     * Overrides the toString method
     */
    public String toString()
    {
        return "CopyMachine[paperCount=" + paperCount +
        ",stapleCount=" + stapleCount + "]";
    }
}