
/**
 * The DonutDisplayTester manipulates a DonutDisplay to confirm that it works
 * as it should!
 *
 * @author Richard White
 * @version 2020-03-31
 */

public class DonutDisplayTester
{
    public static void main(String[] args)
    {
        System.out.print("Setting up an array of Donut objects...");
        Donut[] donuts = {new Donut(3,250,"glazed"),
                          new Donut(3,200,"cake"),
                          new Donut(3,300,"chocolate"),
                          new Donut(3,320,"choc+sprinkles"),
                          new Donut(3,225,"plain old-fash"),
                          new Donut(3,275,"glazed old-fash"),
                          new Donut(3,290,"cinammon roll"),
                          new Donut(3,290,"glazed+sprinkles"),
                          new Donut(3,300,"maple"),
                          new Donut(3,320,"vanilla-icing") };
        System.out.println("done");
        System.out.println("----------------------");
        
        System.out.println("List of donuts to be placed into case:");
        System.out.print("[");
        for (int i = 0; i < donuts.length; i++)
        {
            if (i > 0) { System.out.print(","); }
            System.out.print(donuts[i].getType());
        }
        System.out.println("]");
        System.out.println("----------------------");
        
        System.out.print("Creating DonutDisplay...");
        DonutDisplay dd = new DonutDisplay(3, 4);
        System.out.println("done");
        dd.display();
        System.out.println("----------------------");
        
        System.out.print("Loading donuts into display...");
        dd.loadDonuts(donuts);
        System.out.println("done");
        dd.display();
        System.out.println("----------------------");
        
        System.out.print("Removing a donut from row 1, col 2...");
        Donut removed = dd.removeDonut(1,2); 
        System.out.println("done");
        System.out.println("Donut removed: " + removed.getType());
        dd.display();
        System.out.println("----------------------");
        
        System.out.print("Fixing display...");
        dd.rearrangeDisplay();
        System.out.println("done");
        dd.display();
        System.out.println("----------------------");
        
        System.out.print("Setting up challenging array of Donut objects...");
        Donut[] donuts2 = {null,
                          new Donut(3,200,"cake"),
                          new Donut(3,300,"chocolate"),
                          null,
                          null,
                          new Donut(3,275,"glazed old-fash"),
                          new Donut(3,290,"cinammon roll"),
                          null,
                          new Donut(3,300,"maple"),
                          new Donut(3,320,"vanilla-icing") };
        System.out.println("done");
        System.out.println("----------------------");
        
        System.out.println("List of donuts to be placed into case:");
        System.out.print("[");
        for (int i = 0; i < donuts2.length; i++)
        {
            if (i > 0) { System.out.print(","); }
            if (donuts2[i] != null)
                System.out.print(donuts2[i].getType());
            else
                System.out.print("null");
        }
        System.out.println("]");
        System.out.println("----------------------");
        System.out.print("Loading donuts into display...");
        dd.loadDonuts(donuts2);
        System.out.println("done");
        dd.display();
        System.out.println("----------------------");
        
        System.out.print("Fixing display...");
        dd.rearrangeDisplay();
        System.out.println("done");
        dd.display();
        System.out.println("----------------------");
        
    }
}
