
/**
 * The DonutDisplay class manages a display case of donuts.
 *
 * @author 
 * @version 
 */
public class DonutDisplay
{
    // instance variables
    private Donut[][] display;

    /**
     * Constructor for objects of class DonutDisplay
     * Creates an empty two-dimensional array of Donut objects
     * @param rows the number of rows in the display case
     * @param cols the number of cols in the display case
     */
    public DonutDisplay(int rows, int cols)
    {
        // initialise instance variables
        display = new Donut[rows][cols];
    }

    /**
     * The loadDonuts method takes a 1-dimensional array of
     * Donut objects and loads them into an empty display case as shown.
     * 
     * * For reference, this is a 4x5 display case of 17 donuts:
     * 
     * 
     *                               cols
     *                   0        1       2        3        4
     * display = [
     *          0   [ donut0,  donut1,  donut2,  donut3,  donut4  ],
     *          1   [ donut5,  donut6,  donut7,  donut8,  donut9  ],
     *   rows   2   [ donut10, donut11, donut12, donut13, donut14 ],
     *          3   [ donut15, donut16, null,    null,    null    ]  ]
     * 
     *
     * @param  donuts a one-dimensional array of donuts to be loaded
     *                into the display case
     * PRECONDITION the number of donuts will be <= the capacity of
     *              the display case
     */
    public void loadDonuts(Donut[] donuts)
    {
        // insert code here
    }

    /**
     * Prints out the donut display using printf so that donuts can be
     * displayed in a fixed-width format. Makes it easier to see what donut
     * is located where.
     */
    public void display()
    {
        for (int row = 0; row < display.length; row++)
        {
            for (int col = 0; col < display[0].length; col++)
            {
                if (display[row][col] != null)
                    System.out.printf("%18s ", display[row][col].getType()) ;
                else
                    System.out.printf("%18s ","null");
            }
            System.out.println();
        }
    }

    /**
     * Removes a donut from the display at the specified location, setting the
     * value at that location to null
     * @param row the row of the donut to be removed
     * @param col the col of the donut to be removed
     * @return the Donut object that has been removed
     * PRECONDITION the row and the col refer to a valid Donut object
     */
    public Donut removeDonut(int row, int col)
    {   
        // insert code here
        
        
    }

    /**
     * Rearranges the display case to eliminate empty donut spots. Empty 
     * spots should be replaced by donuts immediately to their right,
     * or from rows farther down in the display case, as needed. There
     * may be multiple donuts that have been removed before calling this
     * method, ie. multiple null spots may need to be filled.
     * 
     * Example: Before rearranging:
     *             glazed           cake                chocolate        choc+sprinkles 
     *             plain old-fash   glazed old-fash     null             glazed+sprinkles
     *             maple            vanilla-icing       null             null
     *             
     *          After rearranging:
     *             glazed           cake                chocolate        choc+sprinkles 
     *             plain old-fash   glazed old-fash     glazed+sprinkles maple      
     *             vanilla-icing    null                null             null
     */
    public void rearrangeDisplay()
    {
        // insert code here
        
        
    }
}
