
/**
 * Write a description of class CarafeTester here.
 *
 * @author Richard White
 * @version 2020-03-29
 */
public class CarafeTester
{
    public static void main(String[] args)
    {
        final double EPSILON = 0.0000000001;
        int testsPassed = 0;
        System.out.print("Creating a new Carafe of French coffee...");
        Carafe c = new Carafe("French");
        System.out.println("passed");
        testsPassed++;
        
        System.out.print("Checking type of coffee (should be \"French\")...");
        if (c.getType().equals("French"))
        {
            System.out.println("passed");
            testsPassed++;
        }
        else
            System.out.println("failed");
        
        System.out.print("Checking that carafe began filled (should be 1 liter)...");
        if (Math.abs(c.getAmount()- 1) < EPSILON)
        {
            System.out.println("passed");
            testsPassed++;
        }
        else
            System.out.println("failed");
        
        System.out.print("Pouring a cup of coffee...");
        if (Math.abs(c.pourCup() - c.CUP) < EPSILON)
        {
            System.out.println("passed");
            testsPassed++;
        }
        else
        {
            System.out.println("failed");
        }
        
        System.out.print("Checking remaining coffee in carafe...");
        if (Math.abs(c.getAmount() - (1 - c.CUP)) < EPSILON)
        {
            System.out.println("passed");
            testsPassed++;
        }
        else
        {
            System.out.println("failed");
        }
        
        System.out.print("Refilling carafe with too much (should be 1 liter)...");
        c.refill(2); // 2 liters? too much!
        if (Math.abs(c.getAmount() - 1) < EPSILON)
        {
            System.out.println("passed");
            testsPassed++;
        }
        else
        {
            System.out.println("failed");
        }
        
        System.out.println("Pouring five cups of coffee (last one should be short...");
        double cupAmount = 0;
        for (int i = 0; i < 5; i++)
        {
            cupAmount = c.pourCup();
            System.out.println("Just poured a cup of " + cupAmount + " ml of coffee.");
        }
        if (Math.abs(cupAmount - 0.0600) < EPSILON)
        {
            System.out.println("passed");
            testsPassed++;
        }
        else
        {
            System.out.println("failed");
        }
        
        System.out.print("Checking remaining coffee in carafe (shouldn't be any)...");
        if (Math.abs(c.getAmount() - 0) < EPSILON)
        {
            System.out.println("passed");
            testsPassed++;
        }
        else
        {
            System.out.println("failed");
        }
        
        System.out.println("Tests passed: " + testsPassed + "/8");
    }
}
