
/**
 * The BasicCopyMachineTester runs a series of tests on a 
 * BasicCopyMachine.
 *
 * @author Richard White
 * @version 2020-03-31
 */
public class BasicCopyMachineTester
{
    public static void main(String[] args)
    {     
        int testsPassed = 0;
        
        System.out.print("Creating new copy machine...");
        BasicCopyMachine cm = new BasicCopyMachine();
        System.out.println("passed.");
        testsPassed++;
        System.out.println("-----------");
        
        System.out.print("Adding paper...");
        cm.addPaper(100);
        System.out.println("passed.");
        testsPassed++;
        System.out.println("-----------");
        
        System.out.print("Testing paper amount...");
        if (cm.getPaperCount() == 100)
        {
            System.out.println("passed");
            testsPassed++;
        }
        else
        {
            System.out.println("failed");
        }
        
        System.out.print("Installing staple cartridge...");
        cm.installStapleCartridge();
        System.out.println("passed.");
        testsPassed++;
        System.out.println("-----------");
        
        System.out.print("Testing staple amount...");
        if (cm.getStapleCount() == 1000)
        {
            System.out.println("passed");
            testsPassed++;
        }
        else
        {
            System.out.println("failed");
        }
        System.out.println("Expected state: CopyMachine[paperCount=100,stapleCount=1000]");
        System.out.println("Actual state:   " + cm);
        System.out.println("-----------");
        
        System.out.println("Making 3 copies of 2-page document...");
        cm.makeCopies(3,2,false);
        if (cm.getPaperCount() == 94 && cm.getStapleCount() == 1000)
        {
            System.out.println("passed");
            testsPassed++;
        }
        else
        {
            System.out.println("failed");
        }
        System.out.println("Expected state: CopyMachine[paperCount=94,stapleCount=1000]");
        System.out.println("Actual state:   " + cm);
        System.out.println("-----------");
        
        System.out.println("Adding paper to exceed capacity of 500...");
        cm.addPaper(500);
        if (cm.getPaperCount() == 500 && cm.getStapleCount() == 1000)
        {
            System.out.println("passed");
            testsPassed++;
        }
        else
        {
            System.out.println("failed");
        }
        System.out.println("Expected state: CopyMachine[paperCount=500,stapleCount=1000]");
        System.out.println("Actual state:   " + cm);
        System.out.println("-----------");
        
        System.out.println("Making 1 copy of 3-page single-sided document and stapling...");
        cm.makeCopies(1,3,true);
        if (cm.getPaperCount() == 497 && cm.getStapleCount() == 999)
        {
            System.out.println("passed");
            testsPassed++;
        }
        else
        {
            System.out.println("failed");
        }
        System.out.println("Expected state: CopyMachine[paperCount=497,stapleCount=999]");
        System.out.println("Actual state:  " + cm);
        System.out.println("-----------");
        
        System.out.println("Refilling machine...");
        cm.addPaper(3);
        System.out.println("Making 500 copies of 5-page single-sided document and stapling...");
        int result = cm.makeCopies(500,5,true);
        System.out.println("Expected error result: 1");
        System.out.println("Actual error result:   " + result);
        if (result == 1)
        {
            System.out.println("passed");
            testsPassed++;
        }
        else
        {
            System.out.println("failed");
        }
        System.out.println("Expected state: CopyMachine[paperCount=500,stapleCount=999]");
        System.out.println("Actual state:   " + cm);
        System.out.println("-----------");
        
        System.out.println("Making 500 copies of 1-page single-sided document and stapling...");
        result = cm.makeCopies(500,1,true);
        System.out.println("Refilling paper...");
        cm.addPaper(500);
        System.out.println("Making 500 copies of 1-page single-sided document and stapling...");
        result = cm.makeCopies(500,1,true);
        System.out.println("Expected error code: 2");
        System.out.println("Actual error result:   " + result);
        if (result == 2)
        {
            System.out.println("passed");
            testsPassed++;
        }
        else
        {
            System.out.println("failed");
        }
        System.out.println("Expected state: CopyMachine[paperCount=500,stapleCount=499]");
        System.out.println("Actual state:   " + cm);
        System.out.println("-----------");
        
        System.out.println("Refilling staple cartridge...");
        cm.installStapleCartridge();
        if (cm.getStapleCount() == 1000)
        {
            System.out.println("passed");
            testsPassed++;
        }
        else
        {
            System.out.println("failed");
        }
        System.out.println("Expected state: CopyMachine[paperCount=500,stapleCount=1000]");
        System.out.println("Actual state:   " + cm);
        System.out.println("-----------");
        
        System.out.println("Tests passed: " + testsPassed + "/11");
    }
}
