
/**
 * The BagelDataTester demonstrates keeping track of BagelData (inventory)
 *
 * @author Richard White
 * @version 2020-03-29
 */

import java.util.ArrayList;

public class BagelDataTester
{
    public static void displayData(ArrayList<BagelData> data)
    {
        System.out.println("------------------");
        System.out.println("   Bagel Data ");
        for (BagelData item : data)
        {
            System.out.println(item);
        }
        System.out.println("------------------");
    }
    
    public static void main(String[] args)
    {
        System.out.print("Creating an (empty) ArrayList of BagelData objects...");
        ArrayList<BagelData> data = new ArrayList<BagelData>();
        System.out.println("done");
        
        System.out.print("Creating a bagel...");
        Bagel b = new Bagel(4,200,"onion");
        System.out.println("done");
        System.out.println(b);
        
        System.out.print("Adding two of this bagel to the ArrayList 'data'...");
        data.add(new BagelData(b,2));
        System.out.println("done");
        
        displayData(data);
        
        System.out.println("Adding three bacon-egg bagels to the ArrayList 'data'...");
        Bagel baconEgg = new Bagel(4,250,"plain");
        baconEgg.addIngredient("egg", 100);
        baconEgg.addIngredient("bacon", 150);
        System.out.println("Bagel: " + baconEgg);
        data.add(new BagelData(baconEgg, 3));
        System.out.println("done");
        
        System.out.print("Modifying the number of onion bagels by +4...");
        for (BagelData d : data)
            if (d.getBagel().getType().equals("onion"))
            {
                d.modifyAmount(4);
            }
        System.out.println("done");
        
        displayData(data);
        
        System.out.print("Resetting onion bagels to one..");
        for (BagelData d : data)
            if (d.getBagel().getType().equals("onion"))
            {
                d.resetAmount(1);
            }
        System.out.println("done");
        
        displayData(data);
        
    }
}
