
/**
 * The BagelData class keeps track of how many bagels there are of a given type, and
 * can be used as part of an bagel inventory program. 
 * 
 * A BagelData object can be considered in this way:
 * 
 *                      +----------------+
 *                      |   BagelData    |
 *                      +----------------+
 *    instance          |     bagel      |
 *    variables   -->   |     amount     |
 *                      +----------------+
 *                      |   getBagel()   |
 *    methods     -->   |  getAmount()   |
 *                      | modifyAmount() |
 *                      | resetAmount()  |
 *                      |   toString()   |
 *                      +----------------+
 *
 * @author 
 * @version 
 */

public class BagelData
{
    
    private Bagel bagel;
    private int amount;
    
    /**
     * Creates a BagelData entry for a bagel object and
     * an initial given count.
     * @param bagel a bagel of a specific type
     * @param amount the number of this type of bagel originally identified
     */
    public BagelData(Bagel bagel, int amount)
    {
        // insert code here
    }
    
    /**
     * Identifies the bagel object in this data
     * @return the bagel object being tracked by this data
     */
    public Bagel getBagel()
    {
        // insert code here
    }
    
    /**
     * Identifies the number of bagels for this data
     * @return the amount of this type of bagel
     */
    public int getAmount()
    {
        // insert code here
    }
    
    /**
     * Changes the number of bagels of this type
     * @param amount the number of bagels to add or subtract
     */
    public void modifyAmount(int amount)
    {
        // insert code here
    }
    
    /**
     * Resets the bagel amount to a new value
     * @param newAmount the number of bagels to reset to
     */
    public void resetAmount (int newAmount)
    {
        // insert code here
    }
    
    /**
     * Overrides toString method
     */
    public String toString()
    {
        return "[bagel=" + bagel + ",amount=" + amount + "]";
    }
}
