
/**
 * Describes a Bagel as a ToroidalBreakfastItem. Once a basic
 * bagel has been constructed, methods can be used to add 
 * ingredients: cream cheese, lox, tomato, egg, bacon, etc.
 *
 * @author 
 * @version 
 */

import java.util.ArrayList;

public class Bagel extends ToroidalBreakfastItem
{
    // instance variables
    private String type;
    private ArrayList<String> ingredients;
    private double ingredientCalories;

    /**
     * Constructor for objects of class Bagel
     * @param radius the radius of the bagel
     * @param calories the calories of the basic bagel
     * @param type the type of bagel (egg, onion, garlic, etc)
     */
    public Bagel(double radius, double calories, String type)
    {
        // initialise instance variables
        
        
        
        
    }

    /**
     * Returns the type of the bagel
     * @return    the bagel type
     */
    public String getType()
    {
        return type;
    }
    
    /**
     * Adds an ingredient to the bagel
     * @param ingredient an ingredient to be included on the bagel
     * @param calories the calories for this ingredient
     */
    public void addIngredient(String ingredient, double calories)
    {
        // insert code here
        
        
    }
    
    /**
     * Gets the ingredients on this bagel
     * @return the bagel's ingredients
     */
    public ArrayList<String> getIngredients()
    {
        return ingredients;
    }
    
    /** Gets the calories for this bagel and its ingredients
     * Overrides the superclass's getCalories
     * @return the total kilocalories
     */
    public double getCalories()
    {
        // insert code here
    }
    
    /**
     * Overrides the toString method
     */
    public String toString()
    {
        String result = super.toString();
        result += "[type=" + type;
        result += ",ingredients=[";
        for (int i = 0; i < ingredients.size(); i++)
        {
            if (i > 0) { result += ","; }
            result += ingredients.get(i);
        }
        result += "],ingredientCalories=" + ingredientCalories + "]]";
        return result;
    }
}
