/**
 * This Processing file demonstrates how to read and write colors in a 
 * Processing Image (PImage)
 *
 * @author Richard White, based on original code from Dom Rosato
 * @version 2025-11-12
 */

// declare instance variables
PImage img;

/**
 * This method modifies the color values of the pixels in the image
 * In this method--upVals--the red, green, and blue colors are all 
 * increased.
 * param img   a PImage object read in to Processing
 */
public void upVals(PImage img)
{
    // Go through the rows of pixels in the image
    for(int row = 0; row < height; row++)
    {
      
        // Go through the columns of pixels in each row
        for(int col = 0; col < width; col++)
        {
            // Get a color object at position col, row
            color c = img.get(col, row);
            
            // Get individual color "channels" from the color image
            float r = red(c);
            float g = green(c);
            float b = blue(c);
            
            // Create a new color object to replace the old one
            color updated = color(r * 50, g + 50, b + 50);
            
            // Set the pixel at the given col, row to this updated color value
            img.set(col, row, updated);
        } 
    }
}

/**
 * Recall that Processing uses a setup() method to run once and initialize
 * the screen to a given size, and then initialize instance variables.
 * You can identify how big the picture is, and therefore how big to make
 * your image size, but looking at its metadata.
 */
void setup()
{
    size(1800, 1200);
    img = loadImage("apcs-perC-small.jpg");
    
    // Display original image
    image(img, 0, 0);  // 0, 0 refers to placing the image in the 
                       // top left of the window 
}  

/**
 * Recall that Processing uses a draw() method to repeatedly execute a 
 * series of instructions. Here, we don't need to keep redrawing the image,
 * so we're going to put a `noLoop();` instruction at the end, which causes
 * the program to stop running.
 */
void draw()
{
    // Call the method to go through and modify the pixels
    upVals(img);
    
    // Display the image again, now with its updated pixel colors
    // image(img, 0, 0);  //0, 0 refers to placing the image in the top left
    
    // Save the updated image to the disk for future use
    // save("edited-picture.jpg");
    
    // Stop the program
    noLoop();
}
