
/**
 * The CashRegisterTester class is used to test students' CashRegister
 * and Coin classes.
 * 
 * @author Richard White 
 * @version 2015-12-08)
 */
public class CashRegisterTester
{
    static final double EPSILON = 1E-12;
    
    public static void main(String[] args)
    {
        int testsPassed = 0;
        System.out.println("Cash register instantiating...");
        CashRegister r = new CashRegister();
        testsPassed++;
        System.out.println(testsPassed + "/7 tests passed");
        System.out.println("Coin 'quarter' instantiating...");
        Coin quarter = new Coin(0.25, "quarter");
        testsPassed++;
        System.out.println(testsPassed + "/7 tests passed");
        System.out.println("Coin 'bitcoin' instantiating...");
        Coin bitcoin = new Coin(364.47, "bitcoin");
        testsPassed++;
        System.out.println(testsPassed + "/7 tests passed");
        System.out.println("Purchase being recorded...");
        r.recordPurchase(5.00);
        testsPassed++;
        System.out.println(testsPassed + "/7 tests passed");
        r.recordPurchase(400.00);
        System.out.println("Entering payment...");
        r.enterPayment(2, quarter);
        testsPassed++;
        System.out.println(testsPassed + "/7 tests passed");
        r.enterPayment(2, bitcoin);
        System.out.println("Getting change...");
        double payBack = r.giveChange();
        testsPassed++;
        System.out.println(testsPassed + "/7 tests passed");
        System.out.println("Change is: " + payBack + "; Expected: 324.44");
        if (Math.abs(payBack - 324.44) < EPSILON) 
            testsPassed++;
        System.out.println(testsPassed + "/7 tests passed");
    }
}
