/**
   A CashRegister totals up sales and computes change due.
   This file needs to be modified so that it can accept
   a Coin class for payment as described in Section 8.2 of
   Horstmann's Java Concepts.
*/
public class CashRegister
{
   private double purchase;
   private double payment;
   
   public static final double QUARTER_VALUE = 0.25;
   public static final double DIME_VALUE = 0.10;
   public static final double NICKEL_VALUE = 0.05;
   public static final double PENNY_VALUE = 0.01;
   
   /**
      Constructs a cash register with no money in it.
   */
   public CashRegister()
   {
      purchase = 0;
      payment = 0;
   }

   /**
      Records the sale of an item.
      @param amount the price of the purchased item
   */
   public void recordPurchase(double amount)
   {
      double newTotal = purchase + amount;
      purchase = newTotal;
   }

   /**
      Enters the payment received form the customer.
      @param dollars the number of dollars in the payment
      @param quarters the number of quarters in the payment
      @param dimes the number of dimes in the payment
      @param nickels the number of nickels in the payment
      @param pennies the number of pennies in the payment
   */
   public void enterPayment (int dollars, int quarters,
                             int dimes, int nickels,
                             int pennies)
   {
       payment = dollars + quarters * QUARTER_VALUE + 
                           dimes * DIME_VALUE +
                           nickels * NICKEL_VALUE +
                           pennies * PENNY_VALUE;
   }
   
   /**
      Computes the change due and resets the machine for the next customer.
      @return the change due to the customer
   */
   public double giveChange()
   {
      double change = payment - purchase;
      purchase = 0;
      payment = 0;
      return change;
   }    
}